/*
 * TeamSpeak 3 plugin for ArmA 2
 * 
 * Authors: [BWF] Le CuLtO / [BWF] Johnson
 */

#ifndef PLUGIN_H
#define PLUGIN_H

#define WINDOWS
#define PLUGINS_EXPORTDLL __declspec(dllexport)

#include <fstream>
#include <iostream>
#include <sstream>
#include <vector>
#include <windows.h>

#include "public_errors.h"
#include "public_definitions.h"
#include "public_rare_definitions.h"
#include "ts3_functions.h"
#include "plugin_events.h"

DWORD WINAPI BouclePressePapier (LPVOID lpParam);
DWORD WINAPI BoucleSon (LPVOID lpParam);
void getIdentity();
void copyToClipboard(std::string& txt);

void move3D(std::string& clip);
void getPlayerID(std::string& clip);
void getPlayerIDFromName(std::string& clip);
void Mute3D(std::string& clip);
void SwitchPlayer(std::string& clip);
void ConnectToServer(std::string& clip);
void GetCurrentChannelID(std::string& clip);
//void GetChannelIDFromName(std::string& clip);

#ifdef __cplusplus
extern "C" {
#endif

/* Required functions */
PLUGINS_EXPORTDLL const char* ts3plugin_name();
PLUGINS_EXPORTDLL const char* ts3plugin_version();
PLUGINS_EXPORTDLL int ts3plugin_apiVersion();
PLUGINS_EXPORTDLL const char* ts3plugin_author();
PLUGINS_EXPORTDLL const char* ts3plugin_description();
PLUGINS_EXPORTDLL void ts3plugin_setFunctionPointers(const struct TS3Functions funcs);
PLUGINS_EXPORTDLL int ts3plugin_init();
PLUGINS_EXPORTDLL void ts3plugin_shutdown();

PLUGINS_EXPORTDLL void ts3plugin_currentServerConnectionChanged(uint64 serverConnectionHandlerID);
PLUGINS_EXPORTDLL void ts3plugin_onConnectStatusChangeEvent(uint64 serverConnectionHandlerID, int newStatus, unsigned int errorNumber);

#ifdef __cplusplus
}
#endif

#endif
